using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class OrbitCalculation : MonoBehaviour
{
    public LineRenderer circleRenderer;
    // Start is called before the first frame update
    [SerializeField] int pasos;
    [SerializeField] float radio;
    void Start()
    {
        DibujarOrbita(pasos , radio);
    }

    // Update is called once per frame
    void Update()
    {
        
    }

    void DibujarOrbita(int steps, float radius)
    {
        circleRenderer.positionCount = steps;
        for (int currentStep = 0; currentStep < steps; currentStep++)
        {
            float circumferenceProgress = (float)currentStep / steps;

            float currentRadian = circumferenceProgress * 2 * Mathf.PI;

            float xScaled = Mathf.Cos(currentRadian);
            float zScaled = Mathf.Sin(currentRadian);

            float x = xScaled * radius;
            float z = zScaled * radius;

            Vector3 currentPosition = new Vector3(x, 0, z);
            Debug.Log("x: " +x + " y: 0 " + " z: " +z);
            circleRenderer.SetPosition(currentStep,currentPosition);
        }
    }
}
