using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

public class UIController : MonoBehaviour
{
    // Componentes
    private Animator _animator;
    public Camera cameraController;

    // Vars
    private int _actualPosition = 0;
    private bool _clickEnabled = true;
    private int _maxFrames = 60;
    private float _waitTime = 2f;
    private List<string> _info;
    private string _path = "Text/Info";
    //private string _path = "Text/InfoCAT";
    

    string msg = "";
    private bool _uiActive;
    private string _actualTag;
    public Canvas uiMovement;
    public Canvas uiInfo;
    
    //UI
    public TextMeshProUGUI title;
    public TextMeshProUGUI spects;
    public TextMeshProUGUI data;
    
    //Planetas
    public TextMeshProUGUI mercury;
    public TextMeshProUGUI venus;
    public TextMeshProUGUI earth;
    public TextMeshProUGUI mars;
    public TextMeshProUGUI jupiter;
    public TextMeshProUGUI saturn;
    public TextMeshProUGUI uranus;
    public TextMeshProUGUI neptune;

    
    void Start()
    {
        //Configuracion rendimiento.
        QualitySettings.vSyncCount = 0;
        Application.targetFrameRate = _maxFrames;

        _animator = gameObject.GetComponent<Animator>();        
        uiInfo.enabled = false;
        CargaDatos(_path);
        NamePlanets();
    }

    
    void Update()
    {
        _uiActive = cameraController.GetComponent<CameraEvents>().MostrarUI;
        _actualTag = cameraController.GetComponent<CameraEvents>().MostrarTag;
        
        UI_Control(_actualPosition);
    }


    IEnumerator Movement(int planetValue)
    {
        _animator.SetInteger("Position", planetValue);
        NamePlanets();
        yield return new WaitForSeconds(_waitTime);
        if (_actualPosition != 0)
        {
            int planet = (planetValue - 1)*4;
            title.text = _info[planet];
            spects.text = _info[planet + 1] + "\n" + _info[planet + 2];
            data.text = _info[planet+3];            
        }
        //Reactivar botones y mostrar UI.
        if ((planetValue != 0) && (_uiActive))
        {
            //uiInfo.enabled = true;  
        }
        
        //uiMovement.GetComponent<Canvas>().enabled = true;
        
    }

    private void UI_Control(int planetValue)
    {
        if (_actualPosition != 0 && _uiActive && _actualTag == "Planet")
        {
            uiInfo.enabled = true;
            //uiMovement.GetComponent<Canvas>().enabled = false;
        }
        else
        {
            uiInfo.enabled = false;
            //uiMovement.GetComponent<Canvas>().enabled = false;
        }
        msg = _info[32];
        //Convertir boton del planeta actual en el de volver atras.
        if (_actualTag == "Planet" || _actualTag == "Solar")
        {
            uiMovement.GetComponent<Canvas>().enabled = true;
            if (planetValue == 1)
            {
                mercury.text = msg;
                mercury.color = Color.yellow;
            }
            else if (planetValue == 2)
            {
                venus.text = msg;
                venus.color = Color.yellow;
            }
            else if (planetValue == 3)
            {
                earth.text = msg;
                earth.color = Color.yellow;
            }
            else if (planetValue == 4)
            {
                mars.text = msg;
                mars.color = Color.yellow;
            }
            else if (planetValue == 5)
            {
                jupiter.text = msg;
                jupiter.color = Color.yellow;
            }
            else if (planetValue == 6)
            {
                saturn.text = msg;
                saturn.color = Color.yellow;
            }
            else if (planetValue == 7)
            {
                uranus.text = msg;
                uranus.color = Color.yellow;
            }
            else if (planetValue == 8)
            {
                neptune.text = msg;
                neptune.color = Color.yellow;
            }
        }
        else
        {
            uiMovement.GetComponent<Canvas>().enabled = false;
        }
    }

//Mover la camara entre posiciones.
    public void ChangePosition(int planetValue)
    {
        if (_clickEnabled)
        {
            //Desactivar botones e interfaz Info
            uiInfo.enabled = false;
            uiMovement.GetComponent<Canvas>().enabled = false;
            //Volver atras si clicamos el mismo planeta
            if (planetValue == _actualPosition)
            {
                _actualPosition = 0;
            }
            //Mover al nuevo planeta selecionado.
            else
            {
                _actualPosition = planetValue;
            }
            StartCoroutine(Movement(_actualPosition));
        }
    }
//Extraer los Datos de los ficheros.
    private void CargaDatos(string path)
    {
        var file = Resources.Load<TextAsset>(path);
        var fileToText = file.text;
        var byLines = fileToText.Split('\n');
        _info = new List<string>(byLines);
    }
//Asignar nombres a planetas y color de texto en blanco.
    private void NamePlanets()
    {
        mercury.text = _info[0];
        venus.text = _info[4];
        earth.text = _info[8];
        mars.text = _info[12];
        jupiter.text = _info[16];
        saturn.text = _info[20];
        uranus.text = _info[24];
        neptune.text = _info[28];
        mercury.color = Color.white;
        venus.color = Color.white;
        earth.color = Color.white;
        mars.color = Color.white;
        jupiter.color = Color.white;
        saturn.color = Color.white;
        uranus.color = Color.white;
        neptune.color = Color.white;
    }
}
